/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.test;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.Predicates;
import org.codefilarete.tool.function.ThrowingRunnable;
import org.codefilarete.tool.reflect.MemberPrinter;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.AssertionFailedError;

public class Assertions {
    public static <E> void assertEquals(E expected, E actual) {
        Assertions.assertPredicate(new ExpectedPredicate<E, E>(expected, Predicates::equalOrNull){

            @Override
            public E giveExpectedFromActual(E actual) {
                return actual;
            }
        }, actual);
    }

    public static <E, M> void assertEquals(final E expected, final E actual, final Function<E, M> mapper) {
        Assertions.assertPredicate(new ExpectedPredicate<M, M>(mapper.apply(expected), Predicates::equalOrNull, new FailureMessageBuilder(){

            @Override
            protected String build(Duo<String, String> messageParameters) {
                return super.build((Duo<String, String>)new Duo((Object)this.wrap(this.toString(mapper.apply(expected))), (Object)this.wrap(this.toString(mapper.apply(actual)))));
            }
        }){

            @Override
            public M giveExpectedFromActual(M actual) {
                return actual;
            }
        }, mapper.apply(actual));
    }

    public static <E> void assertEquals(E expected, E actual, BiPredicate<E, E> predicate) {
        Assertions.assertPredicate(new ExpectedPredicate<E, E>(expected, predicate, new FailureMessageBuilder()){

            @Override
            public E giveExpectedFromActual(E actual) {
                return actual;
            }
        }, actual);
    }

    public static <E> void assertEquals(final E expected, final E actual, BiPredicate<E, E> predicate, final Function<E, String> printingFunction) {
        Assertions.assertPredicate(new ExpectedPredicate<E, E>(expected, predicate, new FailureMessageBuilder(){

            @Override
            protected String build(Duo<String, String> messageParameters) {
                return super.build((Duo<String, String>)new Duo(printingFunction.apply(expected), printingFunction.apply(actual)));
            }
        }){

            @Override
            public E giveExpectedFromActual(E actual) {
                return actual;
            }
        }, actual);
    }

    public static <E> void assertEquals(E expected, E actual, Comparator<E> comparator) {
        Assertions.assertPredicate(new ExpectedPredicate<E, E>(expected, (e, a) -> comparator.compare(e, a) == 0, new FailureMessageBuilder()){

            @Override
            public E giveExpectedFromActual(E actual) {
                return actual;
            }
        }, actual);
    }

    public static <E, M> void assertEquals(final E expected, final E actual, final Function<E, M> mapper, BiPredicate<M, M> predicate) {
        Assertions.assertPredicate(new ExpectedPredicate<E, E>(expected, (e, a) -> predicate.test(mapper.apply(e), mapper.apply(a)), new FailureMessageBuilder(){

            @Override
            protected String build(Duo<String, String> messageParameters) {
                return super.build((Duo<String, String>)new Duo((Object)this.wrap(this.toString(mapper.apply(expected))), (Object)this.wrap(this.toString(mapper.apply(actual)))));
            }
        }){

            @Override
            public E giveExpectedFromActual(E actual) {
                return actual;
            }
        }, actual);
    }

    private static <E, EXP> void assertPredicate(ExpectedPredicate<E, EXP> predicate, E actual) {
        if (!predicate.test(actual)) {
            throw new AssertionFailedError(predicate.giveMessage(actual), predicate.getExpected(), predicate.giveExpectedFromActual(actual));
        }
    }

    public static <E> void assertAllEquals(Iterable<E> expected, Iterable<E> actual) {
        IterableTester<Object, Object> iterableTester = new IterableTester<Object, Object>(Predicates::equalOrNull);
        boolean areEquals = iterableTester.test(expected, actual);
        if (!areEquals) {
            FailureMessageBuilder failureMessageBuilder = new FailureMessageBuilder();
            String failureMessage = failureMessageBuilder.build(expected, actual);
            throw new AssertionFailedError(failureMessage, expected, actual);
        }
    }

    public static <E, M> void assertAllEquals(Iterable<E> expected, final Iterable<E> actual, final Function<E, M> mapper) {
        final List input = Iterables.collectToList(expected, mapper);
        Assertions.assertPredicate(new ExpectedPredicate<Iterable<M>, Iterable<M>>(input, Predicates::equalOrNull, new FailureMessageBuilder(){

            @Override
            protected String build(Duo<String, String> messageParameters) {
                return super.build((Duo<String, String>)new Duo((Object)this.wrap(input.toString()), (Object)this.wrap(Iterables.collectToList((Iterable)actual, (Function)mapper).toString())));
            }
        }){

            @Override
            public Iterable<M> giveExpectedFromActual(Iterable<M> actual) {
                return actual;
            }
        }, Iterables.collectToList(actual, mapper));
    }

    public static <A, B> void assertAllEquals(Iterable<A> expected, Iterable<B> actual, BiPredicate<A, B> biPredicate) {
        IterableTester<A, B> iterableTester = new IterableTester<A, B>(biPredicate);
        boolean areEquals = iterableTester.test(expected, actual);
        if (!areEquals) {
            FailureMessageBuilder failureMessageBuilder = new FailureMessageBuilder();
            String failureMessage = failureMessageBuilder.build(expected, actual);
            throw new AssertionFailedError(failureMessage, expected, actual);
        }
    }

    public static <A, B, M> void assertAllEquals(Iterable<A> expected, Iterable<B> actual, Function<A, M> mapperForAs, Function<B, M> mapperForBs) {
        ArrayList as = new ArrayList();
        ArrayList bs = new ArrayList();
        IterableTester<Object, Object> iterableTester = new IterableTester<Object, Object>((a, b) -> {
            Object mappedA = mapperForAs.apply(a);
            as.add(mappedA);
            Object mappedB = mapperForBs.apply(b);
            bs.add(mappedB);
            return Predicates.equalOrNull(mappedA, mappedB);
        });
        if (!iterableTester.test(expected, actual)) {
            FailureMessageBuilder failureMessageBuilder = new FailureMessageBuilder();
            String failureMessage = failureMessageBuilder.build(expected, actual);
            throw new AssertionFailedError(failureMessage, as, bs);
        }
    }

    public static <E extends Throwable> void assertThrows(ThrowingRunnable<E> executable, Predicate<Throwable> throwablePredicate) {
        try {
            executable.run();
        }
        catch (Throwable actualException) {
            if (!throwablePredicate.test(actualException)) {
                Object expected = null;
                Object expectedFromActual = null;
                if (throwablePredicate instanceof ExpectationPredicate) {
                    expected = ((ExpectationPredicate)throwablePredicate).getExpected();
                    expectedFromActual = ((ExpectationPredicate)throwablePredicate).giveExpectedFromActual(actualException);
                }
                String message = "Unexpected exception thrown";
                if (throwablePredicate instanceof PrintablePredicate) {
                    message = ((PrintablePredicate)((Object)throwablePredicate)).giveMessage(actualException);
                }
                throw new AssertionFailedError(message, expected, expectedFromActual, actualException);
            }
            return;
        }
        throw new AssertionFailedError("Expected exception to be thrown, but nothing was thrown.");
    }

    private static void failNotEqual(Object expected, Object actual) {
        throw new AssertionFailedError(null, expected, actual);
    }

    public static <T extends Throwable, X extends ExpectationPredicate<T, String> & PrintablePredicate<T>> X hasMessage(String message) {
        return (X)new ExpectedPredicate<T, String>(message, (expectedMessage, actualException) -> expectedMessage.equals(actualException.getMessage())){

            @Override
            public String giveMessage(T actual) {
                return "Messages are different";
            }

            @Override
            public String giveExpectedFromActual(T actual) {
                return ((Throwable)actual).getMessage();
            }
        };
    }

    public static <T extends Throwable, X extends ExpectationPredicate<Throwable, Class<T>> & PrintablePredicate<Throwable>> X hasExceptionInCauses(Class<T> throwableClass) {
        return (X)new ThrowableClassExpectedPredicate<T>(throwableClass);
    }

    static String systemToString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    private static class IterableTester<A, B> {
        private final BiPredicate<A, B> biPredicate;

        public IterableTester(BiPredicate<A, B> biPredicate) {
            this.biPredicate = biPredicate;
        }

        public boolean test(Iterable<A> expected, Iterable<B> actual) {
            if (expected == null && actual == null) {
                return true;
            }
            boolean areEquals = true;
            PairIterator.UntilBothIterator duoIterator = new PairIterator.UntilBothIterator(expected, actual);
            while (duoIterator.hasNext()) {
                Duo next = duoIterator.next();
                areEquals &= this.biPredicate.test(next.getLeft(), next.getRight());
            }
            return areEquals;
        }
    }

    private static class FailureMessageBuilder {
        private FailureMessageBuilder() {
        }

        public String build(Object expected, Object actual) {
            String actualString;
            String expectedString = this.toString(expected);
            Duo messageParameters = expectedString.equals(actualString = this.toString(actual)) ? new Duo((Object)this.formatClassAndValue(expected, expectedString), (Object)this.formatClassAndValue(actual, actualString)) : new Duo((Object)this.wrap(expectedString), (Object)this.wrap(actualString));
            return this.build((Duo<String, String>)messageParameters);
        }

        protected String build(Duo<String, String> messageParameters) {
            return "expected: " + (String)messageParameters.getLeft() + " but was: " + (String)messageParameters.getRight();
        }

        protected String wrap(String value) {
            return "<" + value + ">";
        }

        protected String formatClassAndValue(Object value, String valueString) {
            String classAndHash = (String)Nullable.nullable((Object)value).map(Assertions::systemToString).getOr((Object)"null");
            return value instanceof Class ? this.wrap(classAndHash) : classAndHash + this.wrap(valueString);
        }

        protected String toString(Object obj) {
            if (obj instanceof Class) {
                return MemberPrinter.FULL_PACKAGE_PRINTER.toString((Class)obj);
            }
            return StringUtils.nullSafeToString((Object)obj);
        }
    }

    private static class ProjectingPredicateSupport<T extends Throwable>
    implements ExpectationPredicate<Throwable, Object>,
    PrintablePredicate<Throwable> {
        private final ExpectationPredicate<Throwable, ?> projectingPredicate;
        private final ExpectationPredicate<T, ?> projectionPredicate;
        private boolean firstTestMatched;

        public <X extends ExpectationPredicate<Throwable, ?> & ProjectingPredicate<Throwable, T>, Y extends ExpectationPredicate<T, ?> & ProjectingPredicate<Throwable, T>> ProjectingPredicateSupport(X projectingPredicate, Y projectionPredicate) {
            this.projectingPredicate = projectingPredicate;
            this.projectionPredicate = projectionPredicate;
        }

        @Override
        public boolean test(Throwable throwable) {
            this.firstTestMatched = this.projectingPredicate.test(throwable);
            if (this.firstTestMatched) {
                return this.projectionPredicate.test(this.getProjection());
            }
            return false;
        }

        private T getProjection() {
            return (T)((Throwable)((ProjectingPredicate)((Object)this.projectingPredicate)).getProjection());
        }

        @Override
        public Object getExpected() {
            if (!this.firstTestMatched) {
                return this.projectingPredicate.getExpected();
            }
            return this.projectionPredicate.getExpected();
        }

        @Override
        public Object giveExpectedFromActual(Throwable actual) {
            if (!this.firstTestMatched) {
                return this.projectingPredicate.giveExpectedFromActual(actual);
            }
            return this.projectionPredicate.giveExpectedFromActual(this.getProjection());
        }

        @Override
        public String giveMessage(Throwable actual) {
            if (!this.firstTestMatched) {
                return ((PrintablePredicate)((Object)this.projectingPredicate)).giveMessage(actual);
            }
            return ((PrintablePredicate)((Object)this.projectionPredicate)).giveMessage(this.getProjection());
        }
    }

    private static class ThrowableClassExpectedPredicate<T extends Throwable>
    extends ExpectedPredicate<Throwable, Class<T>>
    implements ProjectingPredicate<Throwable, T> {
        private T projection;

        public ThrowableClassExpectedPredicate(Class<T> throwableClass) {
            super(throwableClass, null);
        }

        @Override
        public Class<T> giveExpectedFromActual(Throwable actual) {
            return actual.getClass();
        }

        @Override
        public String giveMessage(Throwable actual) {
            return "Types are different";
        }

        @Override
        public boolean test(Throwable throwable) {
            Throwable foundException = (Throwable)Exceptions.findExceptionInCauses((Throwable)throwable, (Class)((Class)this.getExpected()));
            if (foundException != null) {
                this.projection = foundException;
                return true;
            }
            return false;
        }

        @Override
        public <EXP> Predicate<Throwable> andProjection(ExpectationPredicate<T, EXP> projectionPredicate) {
            return new ProjectingPredicateSupport(this, projectionPredicate);
        }

        @Override
        public T getProjection() {
            return this.projection;
        }
    }

    private static abstract class ExpectedPredicate<E, EXP>
    implements PrintablePredicate<E>,
    ExpectationPredicate<E, EXP> {
        private final EXP expectation;
        private final BiPredicate<EXP, E> predicate;
        private final FailureMessageBuilder messageBuilder;

        public ExpectedPredicate(EXP expectation, BiPredicate<EXP, E> predicate) {
            this(expectation, predicate, new FailureMessageBuilder());
        }

        public ExpectedPredicate(EXP expectation, BiPredicate<EXP, E> predicate, FailureMessageBuilder messageBuilder) {
            this.expectation = expectation;
            this.predicate = predicate;
            this.messageBuilder = messageBuilder;
        }

        @Override
        public String giveMessage(E actual) {
            return this.messageBuilder.build(this.getExpected(), this.giveExpectedFromActual(actual));
        }

        @Override
        public EXP getExpected() {
            return this.expectation;
        }

        @Override
        public boolean test(E e) {
            return this.predicate.test(this.getExpected(), e);
        }
    }

    public static interface ProjectingPredicate<E, P> {
        public <EXP> Predicate<E> andProjection(ExpectationPredicate<P, EXP> var1);

        public P getProjection();
    }

    public static interface PrintablePredicate<E> {
        public String giveMessage(E var1);
    }

    public static interface ExpectationPredicate<E, EXP>
    extends Predicate<E> {
        public EXP getExpected();

        public EXP giveExpectedFromActual(E var1);
    }
}

